<?LassoScript 
define_type:'convert',
	-nameSpace = 'string';

	local:'type'	= '';
	local:'src'		= ''; 
	local:'srctype'	= ''; 
	local:'result'	= '';
	
	local:'textCleanReturns' = regExp(	-find = '[\r\n]+\\s*[\r\n]+',
									-replace = '\r\n',
									-ignorecase 
									);	
	
	local:'textCleanWhite' = regExp(	-find = '[\t ]+',
									-replace = ' ',
									-ignorecase 
									);	
	
	local:'textCleanNumbers' = regExp(	-find = '\\((\\d+)\\).*?(\\d\\d\\d).*?(\\d\\d\\d\\d)',
									-replace = '\\1-\\2-\\3',
									-ignorecase 
									);	
	
	local:'htmlStripWhite' = regExp(	-find = '[\r\n\t]',
										-replace = '',
										-ignorecase 
									);

	local:'htmlStripSpaces' = regExp(	-find = ' +',
										-replace = ' ',
										-ignorecase 
									);
									
	local:'htmlStripTags' = regExp(		-find = '<[^>]*>',
										-replace = '',
										-ignorecase 
									);

	local:'htmlStripLinks' = regExp(	-find = '<a.*?href="(.*?)"[^>]*>(.*?)</a>',
										-replace = '\\2 (\\1)',
										-ignorecase 
									);

	local:'htmlBreaksToPlain' = regExp(	-find = '(?:</div>)|(?:<br>)|(?:<br */>)',
										-replace = '\r\n',
										-ignorecase 
									);

	local:'htmlParasToPlain' = regExp(	-find = '(?:</p>)|(?:</ul>)',
										-replace = '\r\n\r\n',
										-ignorecase 
									);
	
	local:'htmlListToPlain' = regExp(	-find = '<ui>',
										-replace = '	- ',
										-ignorecase,
									);
	
	local:'htmlBreaks' 	= regExp(	-find = '\r\n',
									-replace = '<br />',
									-ignorecase,
									);
	
	local:'htmlLinks' 	= regExp(	-find = '(?<!href=")(?<!">)(?:\\w*://)(\\w+\\.\\w+\\.\\w+[a-z0-9_\\-\\.\\/\\?\\&\\%\\#\\. ])',
										-replace = '<a href="\\0">\\0</a>',
										-ignorecase,
									);

	local:'htmlLazyLinks' = regExp(	-find = '(?<!href=")(?<!">)(?<!//)(?<!\\>)(www.\\w+\\.*\\w+\\.\\w+[a-z0-9_\\-\\.\\/\\?\\&\\%\\#\\. ])',
										-replace = '<a href="http://\\0">\\0</a>',
										-ignorecase,
									);

	local:'htmlMailLinks' = regExp(	-find = '(?<!href=")(?<!">)(?<!mailto:)(?<!\\>)([a-z0-9\\.\\-\\_]+\\@\\w+\\.*\\w+\\.*\\w+\\.\\w+)',
										-replace = '<a href="mailto:\\0">\\0</a>',
										-ignorecase,
									);
	
	local:'wikiBreaks' 	= regExp(	-find = '\r\n',
									-replace = '<br />',
									-ignorecase,
									);

	local:'wikiImages' = regExp(	-find = '\\!(.*?)\\|(.*?)\\|(.*?)x*(.*?)\\!|\\!(.*?)\\|(.*?)\\!|\\!(.*?)\\!',
									-replace = '<img src="\\1\\5\\7" align="\\2\\6" width="\\3" height="\\4">',
									-ignorecase 
								);

	local:'wikiLinks' = regExp(		-find = '\\[(.*?)\\|(.*?)\\]|\\[(.*?)\\]',
									-replace = '<a href="\\1\\3">\\2\\3</a>',
									-ignorecase 
								);

	local:'wikiBold' = regExp(		-find = '\\*(.*?)\\*',
									-replace = '<b>\\1</b>',
									-ignorecase 
								);

	local:'wikiEmphasis' = regExp(	-find = '\\_(.*?)\\_',
									-replace = '<em>\\1</em>',
									-ignorecase 
								);

	local:'wikiUnderline' = regExp(	-find = '\\+(.*?)\\+',
									-replace = '<u>\\1</u>',
									-ignorecase 
								);

	local:'wikiDeleted' = regExp(		-find = '\\-(.*?)\\-',
									-replace = '<del>\\1</del>',
									-ignorecase 
								);


	local:'wikiCited' = regExp(		-find = '\\*(.*?)\\*',
									-replace = '<cite>\\1</cite>',
									-ignorecase 
								);

	local:'wikiSuperscript' = regExp(	-find = '\\*(.*?)\\*',
									-replace = '<sup>\\1</sup>',
									-ignorecase 
								);

	local:'wikiSubscript' = regExp(		-find = '\\*(.*?)\\*',
									-replace = '<sub>\\1</sub>',
									-ignorecase 
								);

	local:'wikiTeletype' = regExp(	-find = '\\*(.*?)\\*',
									-replace = '<tt>\\1</tt>',
									-ignorecase 
								);
								
	local:'wikiBullets' = regExp(	-find = '\r\n- ([^\r\n]*)',
									-replace = '\r\n<ul><li>\\1</li></ul>',
									-ignorecase 
								);
								
	local:'wikiNumbers' = regExp(	-find = '\r\n# ([^\r\n]*)',
									-replace = '\r\n<ol><li>\\1</li></ol>',
									-ignorecase 
								);
								
	local:'wikiHeaders' = regExp(	-find = '\r\nH(\\d)([^\r\n]*)',
									-replace = '\r\n<H\\1>\\2</H\\1>',
									-ignorecase 
								);
								
	local:'wikiClean' = regExp(	-find = '(?:</ul>\r\n<ul>)|(?:</ol>\r\n<ol>)|(?:(</H3>)<br />)',
									-replace = '//1',
									-ignorecase 
								);


	define_tag:'onCreate',
		-optional='src';

		!local_defined('src')?local:'src'=string;
		
		self->'src' 	= #src;
		self->'result'	= string(#src);

	/define_tag;	

	define_tag:'onConvert';
		return:self->'result';
	/define_tag;


	define_tag:'wiki';
		local:'procs' = 'wikiImages,wikiLinks,wikiBold,wikiEmphasis,wikiUnderline,wikiDeleted,wikiCited,wikiSuperscript,wikiTeletype,wikiBullets,wikiNumbers,wikiHeaders,wikiClean,wikiBreaks'->split(',');
		local:'input' = @self->'result';
		
		iterate:#procs,local('proc');
			#input = self->#proc->replaceAll(-input = #input);		
		/iterate;

		return:self;	
	/define_tag;


	define_tag:'cleanNumbers';
		local:'input' = self->'result';
		self->'result' = (
			self->textCleanNumbers->replaceAll(
				-input = self->'result'
			)
		);
		return:self;	
	/define_tag;


	define_tag:'cleanText';
		local:'input' = self->'result';
		self->'result' = (
			self->textCleanWhite->replaceAll(
				self->textCleanReturns->replaceAll(
					-input = self->'result'
				)
			)
		);
		return:self;	
	/define_tag;

	define_tag:'html';
		local:'input' = self->'result';
		self->'result' = (
			self->htmlBreaks->replaceAll(
				self->htmlMailLinks->replaceAll(
					self->htmlLazyLinks->replaceAll(
						self->htmlLinks->replaceAll(
							-input = self->'result'
						)
					)
				)
			)
		);
		return:self;	
	/define_tag;	
	
	define_tag:'plainText';
		self->'result' = (
			self->htmlStripTags->replaceAll(
				self->htmlStripLinks->replaceAll(
					self->htmlListToPlain->replaceAll(
						self->htmlParasToPlain->replaceAll(
							self->htmlBreaksToPlain->replaceAll(
								self->htmlStripSpaces->replaceAll(
									self->htmlStripWhite->replaceAll(
										-input=self->'result'
									)
								)
							)
						)
					)
				)
			)
		);
		return:self;
	/define_tag;	

	define_tag:'dedupe';
		local:'reg'	= regExp(	-find = '(.*?\r\n|$)',
								-replace = '',
								-input	= self->'result',
								-ignorecase 
							);
		local:'last' = '';
		local:'rep' = '';
		while:#reg->find;
			local:'match' = #reg->matchString;
			#match == #last ? #reg->appendReplacement('');
			#last=#match;
		/while;
		#reg->appendTail;
		
		self->'result' = #reg->output;
		return:self;
		
	/define_tag;

	
	
	define_tag:'lassoLinks';
		local:'reg'	= regExp(	-find = '\\[/{0,1}(.*?)\\]',
								-replace = '[\\1]',
								-input	= self->'result',
								-ignorecase 
							);
						
		while:#reg->find;
			local:'match' = #reg->matchString;
			local:'url'	= encode_taglink(#match);
			#match='<a href="'#url'">'#match'</a>';
			#reg->appendReplacement(#match);
		/while;
		#reg->appendTail;
		
		self->'result' = #reg->output;
		return:self;
		
	/define_tag;



/define_type;
	
?>